******************************************************
* LED5HZ.SRC                                         *
*                                                    *
* This is a count program.  It repeatedly counts     *
* from 0 through F and outputs the count to the      *
* 7-segment LED connected to OP0-OP6.  The rate of   *
* counting is 5 Hz.                                  *
******************************************************
DUART    EQU      $00C001     ;68681 base address
OPR_SET  EQU      14*2        ;set bit command reg.
OPR_CLR  EQU      15*2        ;clear bit command reg.
ONE_SEC  EQU      204800      ;1 second delay count

         ORG      $8000
LED5HZ   MOVEA.L  #DUART,A0   ;A0 points to 68681
         CLR.B    D1          ;use D1 as counter
LOOP     MOVE.B   D1,D0       ;use D0 for look-up
         ANDI.W   #$F,D0      ;clear bits 4-15
         BSR.S    CONVERT     ;convert to 7-seg code
         BSR.S    OUT681      ;update LEDs
         MOVE.L   #ONE_SEC/5,D7
         BSR.S    DELAY       ;rest here awhile
         ADDQ     #1,D1       ;increment counter
         BRA      LOOP        ;repeat

******************************************************
* CONVERT - CONVERT a 4-bit code to a 7-segment code *
*                                                    *
*        ENTRY    D0[0:3] contains 4-bit code        *
*                 D0[4-15] cleared                   *
*        ENTRY    D0[0:6] contains 7-segment code    *
*        USES     no subroutines                     *
******************************************************
CONVERT  MOVE.B   TABLE(PC,D0.W),D0 ;table look-up
         RTS
TABLE    DC.B     $01,$4F,$12,$06   ;7-segment LED
         DC.B     $4C,$24,$20,$0F   ;  patterns
         DC.B     $00,$0C,$08,$60
         DC.B     $31,$42,$30,$38

******************************************************
* OUT681 - OUTput data to 68681 output port          *
*                                                    *
*        ENTER:   D0[0:7] contains data to output    *
*                 A0 points to 68681 DUART           *
*        EXIT:    all registers intact               *
*        USES:    no subroutines                     *
******************************************************
OUT681   MOVE.B   D0,OPR_CLR(A0) ;clr. bits, set pins
         NOT.B    D0
         MOVE.B   D0,OPR_SET(A0) ;set bits, clr. pins
         NOT.B    D0             ;restore D0
         RTS

******************************************************
* DELAY - create a software DELAY using D7 as count  *
*                                                    *
*        ENTER:   D7[0:31] contains count            *
*        EXIT:    D7 = 0                             *
*                 all other registers intact         *
*        USES:    no subroutines                     *
*                                                    *
* NOTE: If the 68000 is operating from a 3.6864 MHz  *
* crystal, the delay equals COUNT x 18/3686400 sec.  *
******************************************************
DELAY    SUBQ.L   #1,D7    ;8 cycles
         BNE      DELAY    ;10 cycles (branch taken)
         RTS
         END      LED5HZ
